<?php


if ( !defined('ABSPATH' ) )
    exit();

add_filter( 'trp_machine_translation_engines', 'trp_gt_add_engine_rockai', 10 );
function trp_gt_add_engine_rockai( $engines ){
    $engines[] = array( 'value' => 'rockai_translate', 'label' => __( 'rockai Translate', 'translatepress-multilingual' ) );

    return $engines;
}

add_action( 'wp_ajax_test_translate_txt', 'test_translate_txt');
function test_translate_txt(){
  	$trp                = TRP_Translate_Press::get_trp_instance();
  	$machine_translator = $trp->get_component( 'machine_translator' );
    $text = $_GET['text'];
    $lang = $_GET['lang'];
    $res = $machine_translator->translate([$text],$lang,'en_US');
    if($res){
        echo json_encode(['code'=>200,'data'=>$res[$text]]);exit;
    }else{
        echo json_encode(['code'=>1,'message'=>'translate error!']);exit;
    }
  	
}

add_action( 'trp_machine_translation_extra_settings_middle', 'trp_gt_add_settings_rockai' );

function trp_gt_add_settings_rockai( $mt_settings ){
    $trp                = TRP_Translate_Press::get_trp_instance();
    $machine_translator = $trp->get_component( 'machine_translator' );

    $translation_engine = isset( $mt_settings['translation-engine'] ) ? $mt_settings['translation-engine'] : '';
    $api_key = isset( $mt_settings['rockai-translate-key'] ) ? $mt_settings['rockai-translate-key'] : '';

    // Check for API errors only if $translation_engine is Google.
    if ( 'rockai_translate' === $translation_engine ) {
        $api_check =true;

    }

    // Check for errors.
    $error_message = '';
    $show_errors   = false;
    if ( isset( $api_check ) && true === $api_check['error'] ) {
        $error_message = $api_check['message'];
        $show_errors    = true;
    }

    $text_input_classes = array(
        'trp-text-input',
    );
    if ( $show_errors && 'rockai_translate' === $translation_engine ) {
        $text_input_classes[] = 'trp-text-input-error';
    }
    ?>
    <div class="trp-engine trp-automatic-translation-engine__container" id="rockai_translate">
        <span class="trp-primary-text-bold"><?php esc_html_e( 'rockai Translate API Key', 'translatepress-multilingual' ); ?> </span>

        <div class="trp-automatic-translation-api-key-container">
            <input type="text" id="trp-g-translate-key" placeholder="<?php esc_html_e( 'Add your API Key here...', 'translatepress-multilingual' ); ?>" class="<?php echo esc_html( implode( ' ', $text_input_classes ) ); ?>" name="trp_machine_translation_settings[rockai-translate-key]" value="<?php if( !empty( $mt_settings['rockai-translate-key'] ) ) echo esc_attr( $mt_settings['rockai-translate-key']);?>"/>
            
            <?php
            // Only show errors if Google Translate is active.
            if ( 'rockai_translate' === $translation_engine && function_exists( 'trp_output_svg' ) ) {
                $machine_translator->automatic_translation_svg_output( $show_errors );
            }
            ?>
        </div>

        <?php
        if ( $show_errors && 'rockai_translate' === $translation_engine ) {
            ?>
            <span class="trp-error-inline trp-settings-error-text">
                <?php echo wp_kses_post( $error_message ); ?>
            </span>
            <?php
        }
        ?>
        <span class="trp-primary-text-bold">Translate Test</span>
        <div class="trp-automatic-translation-api-key-container">
            <input type="text" style="max-width: 531px;" id="test_translate_txt" placeholder="Please add English text to test" class="<?php echo esc_html( implode( ' ', $text_input_classes ) ); ?>" name="test_translate_txt" value=""/>
            <?php $trp_settings = get_option( 'trp_settings', false );
                if(isset($trp_settings['translation-languages']) && $trp_settings['translation-languages']){?>
            <select id="test_translate_select_language" class="trp-select2">
                <?php foreach($trp_settings['translation-languages'] as $val){?>
                <option title="<?php echo $val;?>" value="<?php echo $val;?>" ><?php echo $val;?></option>
                <?php }?>
            </select>
            <?php }?>
            <button type="button" class="trp-button-secondary test_translate_btn">Test Translate </button>
        </div>
        <div class="trp-automatic-translation-api-key-container translate_after" >
            <input type="text" style="max-width: 100%;width:100%" id="test_translate_txt_after" class="<?php echo esc_html( implode( ' ', $text_input_classes ) ); ?>" placeholder="Translate Results" name="test_translate_txt_after" value=""/>
        </div>
        <script>
            jQuery( document ).ready( function( $ ) {
                $('.test_translate_btn').click(function(){
                    var text = $("#test_translate_txt").val();
                    var selectedlang = $('#test_translate_select_language').val();
                    $("#test_translate_txt_after").val('Translating...')
                    if(!text){
                        $(".translate_after").css('display','block');
                        $("#test_translate_txt_after").val('text cannot empty!');
                    }else{
                        $.ajax({
                          type:"GET",
                          url:'/wp-admin/admin-ajax.php?action=test_translate_txt',
                          data:{'text':text,'lang':selectedlang},
                          dataType:"json",
                          success:function(data){
                          	if(data.code == 200){
                                $("#test_translate_txt_after").val(data.data);
                            }else{
                                $("#test_translate_txt_after").val(data.message);
                            }
                          }
                        });
                    }
                })
            })
            
        </script>
        <span class="trp-description-text">
            <?php echo wp_kses( __( '' ), [ 'a' => [ 'href' => [], 'title' => [], 'target' => [] ], 'strong' => [] ] ); ?>
            <br>Please get the API key from <a href="https://rockapi.com/apihub/e2dbc665-b25c-40c5-b597-682e3f13dea2?invite_code=89c20289-b26f-4e2e-804a-4d81ee72be9d" target="_blank">rockapi.com</a>
        </span>
    </div>

    <?php
}

add_filter( 'trp_machine_translation_sanitize_settings', 'trp_gt_sanitize_settings_rockai' );
function trp_gt_sanitize_settings_rockai( $mt_settings ){
    if( !empty( $mt_settings['rockai-translate-key'] ) )
        $mt_settings['rockai-translate-key'] = sanitize_text_field( $mt_settings['rockai-translate-key']  );

    return $mt_settings;
}
